# include <obdefs.h>
# include <sliders.h>

# define GET				-1
# define TONE_MIN			0
# define TONE_MAX			1023		/* ( x 4) would be 4095 with LONG sliders	*/
# define VOL_MIN			0
# define VOL_MAX			15
# define NSE_MIN			0
# define NSE_MAX			31
# define E_P_MIN			0
# define E_P_MAX			4095		/* ( x 16) would be 65535 with LONG sliders	*/
# define E_S_MIN			8
# define E_S_MAX			15

al1_sliders(s_tree)
struct object *s_tree; {
	
			unsigned int period();
			int x;
			extern struct slide s_vals[];
			extern int n_en_a, n_en_b, n_en_c;
			extern int t_en_a, t_en_b, t_en_c;
			extern int r_e_a, r_e_b, r_e_c;
			extern int r_m_a, r_m_b, r_m_c;
			extern int radio_a, radio_b, radio_c;
			
			set_slider(&s_vals[S_T_A],s_tree,tone(0,GET) >> 2, TONE_MIN, TONE_MAX);
			set_slider(&s_vals[S_T_B],s_tree,tone(1,GET) >> 2, TONE_MIN, TONE_MAX);
			set_slider(&s_vals[S_T_C],s_tree,tone(2,GET) >> 2, TONE_MIN, TONE_MAX);
			set_slider(&s_vals[S_V_A],s_tree,volume(0,GET) >> 2, VOL_MIN, VOL_MAX);
			set_slider(&s_vals[S_V_B],s_tree,volume(1,GET) >> 2, VOL_MIN, VOL_MAX);
			set_slider(&s_vals[S_V_C],s_tree,volume(2,GET) >> 2, VOL_MIN, VOL_MAX);
			set.slider(&s_vals[S_N],s_tree,noise(GET),NSE_MIN,NSE_MAX);
			x = shape(GET);
			if( x < 4 )				/* redundant shapes 0-3 > 9 */
				x = 9;
			if( x < 8 )				/* redundant shapes 4-7 > 15 */
				x = 15;
			shape(x);
			set_slider(&s_vals[S_S],s_tree,shape(GET),E_S_MIN,E_S_MAX);
			set_slider(&s_vals[S_P],s_tree,period(GET)  4,E_P_MIN,E_P_MAX);
			select_on( s_tree, noise_enable(0,GET), n_en_a );
			select_on( s_tree, noise_enable(1,GET), n_en_b );
			select_on( s_tree, noise_enable(2,GET), n_en_c );
			select_on( s_tree, tone_enable(0,GET), t_en_a );
			select_on( s_tree, tone_enable(1,GET), t_en_b );
			select_on( s_tree, tone_enable(2,GET), t_en_c );
			select_on( s_tree, mode_bit(0,GET), r_e_a );
			select_on( s_tree, !mode_bit(0,GET), r_m_a );
			select_on( s_tree, mode_bit(1,GET), r_e_b );
			select_on( s_tree, !mode_bit(1,GET), r_m_b );
			select_on( s_tree, mode_bit(2,GET), r_e_c );
			select_on( s_tree, !mode_bit(2,GET), r_m_c );
			save_state();
}
